@echo off
setlocal
@rem generates and compiles the .NET proxy classes and precompiled XmlSerializers
@rem and builds all the C# samples in debug mode.

@rem INCLUDE, LIB and LIBPATH are not required
@rem since we're only building C# samples
set INCLUDE=
set LIB=
set LIBPATH=

rem change to batch file directory and drive
pushd "%~dp0"

@rem generate optimized stubs and precompiled serializer dll for the Converter wsdl files
@rem and a DLL containing the optimized stubs named ConverterSDKStub, and
@rem a DLL containing precompiled XmlSerializers named ConverterSDKStub.XmlSerializers.dll
call genconverterstubs.cmd ..\..\wsdl\converter ConverterApi stage ConverterObjects.cs . ConverterSDKStub
if ERRORLEVEL 1 goto err

@echo Building Samples in Debug mode
if EXIST build.log del -f build.log
@echo "**** Compiling ConverterSamples.sln"
if defined SGenToolPath (
MSBuild.exe cs\ConverterSamples.sln  /t:Rebuild /p:Configuration=Debug /property:SGenToolPath="%SGenToolPath:"=%" 1>build.log 2>&1
) else (
MSBuild.exe cs\ConverterSamples.sln /t:Rebuild /p:Configuration=Debug 1>build.log 2>&1
)
if ERRORLEVEL 1 type build.log && exit /b 1
type build.log

@echo Done Building optimized Stubs and all Samples
goto end

:err_no_DEVENV
@echo Error: No .NET Development environment or tools found installed
@echo        If you have Visual Studio 2019 with ".NET Desktop development",
@echo        please run this from "Developer Command Prompt for VS2019"
@echo        -
@echo        Please use quotes around directory names with spaces in them.

:err
exit /b 1

:end
popd

